/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.Messages;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.internal.typebinding.TypeBindingBuilder;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.parsing.IParseState;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org2.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org2.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.corext.NodeFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.OccurrencesFinderFactory;
import org2.eclipse.php.internal.ui.viewsupport.ISelectionListenerWithAST;
import org2.eclipse.php.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org2.eclipse.php.ui.editor.SharedASTProvider;

class OccurrencesUpdater
implements IPropertyChangeListener {
    private PHPSourceEditor editor;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkMethodOccurrences;
    private boolean fMarkFunctionOccurrences;
    private boolean fMarkConstantOccurrences;
    private boolean fMarkGlobalVariableOccurrences;
    private boolean fMarkLocalVariableOccurrences;
    private boolean fMarkImplementors;
    private boolean fMarkMethodExitPoints;
    private boolean fMarkBreakContinueTargets;
    private boolean fMarkExceptions;
    private ISelection fForcedMarkOccurrencesSelection;
    private Annotation[] fOccurrenceAnnotations;
    private ActivationListener fActivationListener;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private IRegion fMarkOccurrenceTargetRegion;
    private long fMarkOccurrenceModificationStamp;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;

    protected OccurrencesUpdater(PHPSourceEditor editor) {
        this.editor = editor;
    }

    protected void initialize(IPreferenceStore store) {
        this.fMarkOccurrenceAnnotations = store.getBoolean("com.aptana.editor.common.editorMarkOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkMethodOccurrences = store.getBoolean("markMethodOccurrences");
        this.fMarkFunctionOccurrences = store.getBoolean("markFunctionOccurrences");
        this.fMarkConstantOccurrences = store.getBoolean("markConstantOccurrences");
        this.fMarkGlobalVariableOccurrences = store.getBoolean("markGlobalVariableOccurrences");
        this.fMarkLocalVariableOccurrences = store.getBoolean("markLocalVariableOccurrences");
        this.fMarkImplementors = store.getBoolean("markImplementors");
        this.fMarkMethodExitPoints = store.getBoolean("markMethodExitPoints");
        this.fMarkBreakContinueTargets = store.getBoolean("markBreakContinueTargets");
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        if (this.editor.isMarkingOccurrences()) {
            this.installOccurrencesFinder(true);
        }
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, Program astRoot) {
                OccurrencesUpdater.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this.editor, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.editor.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.editor.getSelectionProvider().getSelection();
            ISourceModule source = this.editor.getSourceModule();
            if (source != null) {
                try {
                    Program ast = SharedASTProvider.getAST((ISourceModule)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, (IProgressMonitor)this.editor.getProgressMonitor());
                    this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, ast);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error installing the PHP occurrences finder", (Throwable)e);
                }
            }
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this.editor, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected void dispose() {
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
        this.uninstallOccurrencesFinder();
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, Program ast) {
        IOccurrencesFinder finder;
        int type;
        Expression name;
        IOccurrencesFinder finder2;
        IDocument document;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (ast == null || selection == null) {
            return;
        }
        if (!ast.isBindingCompleted()) {
            TypeBindingBuilder.buildBindings(ast);
        }
        if ((document = this.editor.getISourceViewer().getDocument()) == null) {
            return;
        }
        if (document.getLength() != ast.getEnd()) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        ASTNode selectedNode = NodeFinder.perform((ASTNode)ast, (int)selection.getOffset(), (int)selection.getLength());
        if (locations == null && this.fMarkMethodExitPoints && (finder2 = OccurrencesFinderFactory.createMethodExitsFinder()).initialize(ast, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkImplementors && (finder2 = OccurrencesFinderFactory.createIncludeFinder()).initialize(ast, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkBreakContinueTargets && (finder2 = OccurrencesFinderFactory.createBreakContinueTargetFinder()).initialize(ast, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (locations == null && this.fMarkImplementors && (finder2 = OccurrencesFinderFactory.createImplementorsOccurrencesFinder()).initialize(ast, selectedNode) == null) {
            locations = finder2.getOccurrences();
        }
        if (selectedNode != null && selectedNode.getType() == 60 && (name = ((Variable)selectedNode).getName()) instanceof Identifier) {
            selectedNode = name;
        }
        if (locations == null && selectedNode != null && (selectedNode instanceof Identifier || this.isNonStringScalar(selectedNode)) && this.isMarkingOccurrencesFor(type = PhpElementConciliator.concile((ASTNode)selectedNode)) && (finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type)) != null && finder.initialize(ast, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        if (locations == null) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            } else if (hasChanged) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.setPriority(50);
        this.fOccurrencesFinderJob.schedule();
    }

    private Object getAnnotationModelLock(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private boolean isNonStringScalar(ASTNode node) {
        return node.getType() == 51 && node.getParent().getType() != 47;
    }

    private boolean isMarkingOccurrencesFor(int type) {
        switch (type) {
            case 1: {
                return this.fMarkGlobalVariableOccurrences;
            }
            case 3: {
                return this.fMarkLocalVariableOccurrences;
            }
            case 2: {
                return this.fMarkFunctionOccurrences;
            }
            case 4: {
                return this.fMarkTypeOccurrences;
            }
            case 5: {
                return this.fMarkConstantOccurrences;
            }
            case 6: {
                return this.fMarkMethodOccurrences;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.editor.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getAnnotationModelLock(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean newBooleanValue = false;
        Object newValue = event.getNewValue();
        if (newValue != null) {
            newBooleanValue = Boolean.valueOf(newValue.toString());
        }
        if ("com.aptana.editor.common.editorMarkOccurrences".equals(property)) {
            if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                this.fMarkOccurrenceAnnotations = newBooleanValue;
                if (!this.fMarkOccurrenceAnnotations) {
                    this.uninstallOccurrencesFinder();
                } else {
                    this.installOccurrencesFinder(true);
                }
            }
            return;
        }
        if ("markTypeOccurrences".equals(property)) {
            this.fMarkTypeOccurrences = newBooleanValue;
            return;
        }
        if ("markMethodOccurrences".equals(property)) {
            this.fMarkMethodOccurrences = newBooleanValue;
            return;
        }
        if ("markFunctionOccurrences".equals(property)) {
            this.fMarkFunctionOccurrences = newBooleanValue;
            return;
        }
        if ("markConstantOccurrences".equals(property)) {
            this.fMarkConstantOccurrences = newBooleanValue;
            return;
        }
        if ("markGlobalVariableOccurrences".equals(property)) {
            this.fMarkGlobalVariableOccurrences = newBooleanValue;
            return;
        }
        if ("markLocalVariableOccurrences".equals(property)) {
            this.fMarkLocalVariableOccurrences = newBooleanValue;
            return;
        }
        if ("markMethodExitPoints".equals(property)) {
            this.fMarkMethodExitPoints = newBooleanValue;
            return;
        }
        if ("markBreakContinueTargets".equals(property)) {
            this.fMarkBreakContinueTargets = newBooleanValue;
            return;
        }
        if ("markImplementors".equals(property)) {
            this.fMarkImplementors = newBooleanValue;
            return;
        }
        if ("stickyOccurrences".equals(property)) {
            this.fStickyOccurrenceAnnotations = newBooleanValue;
            return;
        }
    }

    public void beforeParse(IParseState parseState) {
    }

    public void afterParse(IParseState parseState) {
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == OccurrencesUpdater.this.editor.getEditorSite().getWorkbenchWindow() && OccurrencesUpdater.this.fMarkOccurrenceAnnotations && OccurrencesUpdater.this.editor.isActiveEditor()) {
                OccurrencesUpdater.this.fForcedMarkOccurrencesSelection = OccurrencesUpdater.this.editor.getSelectionProvider().getSelection();
                ISourceModule sourceModule = OccurrencesUpdater.this.editor.getSourceModule();
                if (sourceModule != null && sourceModule.getElementType() == 5) {
                    try {
                        OccurrencesUpdater.this.updateOccurrenceAnnotations((ITextSelection)OccurrencesUpdater.this.fForcedMarkOccurrencesSelection, SharedASTProvider.getAST((ISourceModule)sourceModule, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, (IProgressMonitor)OccurrencesUpdater.this.editor.getProgressMonitor()));
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP code-scanner - Update error", (Throwable)e);
                    }
                }
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == OccurrencesUpdater.this.editor.getEditorSite().getWorkbenchWindow() && OccurrencesUpdater.this.fMarkOccurrenceAnnotations && OccurrencesUpdater.this.editor.isActiveEditor()) {
                OccurrencesUpdater.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    class OccurrencesFinderJob
    extends Job {
        protected static final String WRITE_OCCURRENCE_ID = "com.aptana.php.ui.occurrences.write";
        protected static final String READ_OCCURRENCE_ID = "com.aptana.php.ui.occurrences";
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        protected OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super(Messages.PHPSourceEditor_markOccurrencesJob_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            ISelectionProvider selectionProvider = OccurrencesUpdater.this.editor.getSelectionProvider();
            this.fPostSelectionValidator = selectionProvider instanceof ISelectionValidator ? (ISelectionValidator)selectionProvider : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && OccurrencesUpdater.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = OccurrencesUpdater.this.editor.getISourceViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = OccurrencesUpdater.this.editor.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)OccurrencesUpdater.this.editor.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation occurrence = this.fLocations[i];
                Position position = new Position(occurrence.getOffset(), occurrence.getLength());
                String description = occurrence.getDescription();
                String annotationType = occurrence.getFlags() == 1 ? WRITE_OCCURRENCE_ID : READ_OCCURRENCE_ID;
                Annotation annotation = new Annotation(annotationType, false, description);
                annotationMap.put(annotation, position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = OccurrencesUpdater.this.getAnnotationModelLock(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(OccurrencesUpdater.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    OccurrencesUpdater.this.removeOccurrenceAnnotations();
                    for (Map.Entry entry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                    }
                }
                OccurrencesUpdater.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = OccurrencesUpdater.this.editor.getISourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = OccurrencesUpdater.this.editor.getISourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = OccurrencesUpdater.this.editor.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)OccurrencesUpdater.this.editor.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (OccurrencesUpdater.this.fOccurrencesFinderJob != null) {
                OccurrencesUpdater.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }
}

